<?php

namespace App\Repositories;

use App\Contracts\Repositories\CustomerWalletRepositoryInterface;
use App\Models\CustomerWallet;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Pagination\LengthAwarePaginator;

class CustomerWalletRepository implements CustomerWalletRepositoryInterface
{
    public function __construct(
        private readonly CustomerWallet           $customerWallet,
    )
    {
    }


    public function add(array $data): string|object
    {
        return $this->customerWallet->create($data);
    }

    public function getFirstWhere(array $params, array $relations = []): ?Model
    {
        return $this->customerWallet->where($params)->with($relations)->first();
    }

    public function getList(array $orderBy = [], array $relations = [], int|string $dataLimit = DEFAULT_DATA_LIMIT, ?int $offset = null): Collection|LengthAwarePaginator
    {
        $query = $this->customerWallet->with($relations)
            ->when(!empty($orderBy), function ($query) use ($orderBy) {
                return $query->orderBy(array_key_first($orderBy),array_values($orderBy)[0]);
            });

        return $dataLimit == 'all' ? $query->get() : $query->paginate($dataLimit);
    }

    public function getListWhere(array $orderBy = [], ?string $searchValue = null, array $filters = [], array $relations = [], int|string $dataLimit = DEFAULT_DATA_LIMIT, ?int $offset = null): Collection|LengthAwarePaginator
    {
        $query = $this->customerWallet->with($relations)
            ->when(isset($filters['id']), function ($query) use ($filters) {
                return $query->where(['id' => $filters['id']]);
            })
            ->when(!empty($orderBy), function ($query) use ($orderBy) {
                return $query->orderBy(array_key_first($orderBy), array_values($orderBy)[0]);
            });

        $filters += ['searchValue' => $searchValue];
        return $dataLimit == 'all' ? $query->get() : $query->paginate($dataLimit)->appends($filters);
    }

    public function update(string $id, array $data): bool
    {
        return $this->customerWallet->find($id)->update($data);
    }

    public function delete(array $params): bool
    {
        $this->customerWallet->where($params)->delete();
        return true;
    }
}
